<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;
use Cake\Auth\DefaultPasswordHasher;

/**
 * Users Model
 *
 * @property \Cake\ORM\Association\BelongsTo $Companies
 * @property \Cake\ORM\Association\BelongsTo $Branches
 * @property \Cake\ORM\Association\BelongsTo $Groups
 * @property \Cake\ORM\Association\HasMany $Posts
 *
 * @method \App\Model\Entity\User get($primaryKey, $options = [])
 * @method \App\Model\Entity\User newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\User[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\User|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\User patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\User[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\User findOrCreate($search, callable $callback = null)
 *
 * @mixin \Cake\ORM\Behavior\TimestampBehavior
 */

class UsersTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);
        
        $this->addBehavior('Acl.Acl', ['type' => 'requester']);
        $this->table('users');
        $this->displayField('accountno');
        $this->primaryKey('id');

        $this->addBehavior('Timestamp');

        $this->belongsTo('Groups', [
            'foreignKey' => 'group_id',
            'joinType' => 'INNER'
        ]);
        $this->belongsTo('Companies', [
            'foreignKey' => 'company_id',
            'joinType' => 'INNER'
        ]);
        $this->belongsTo('Branches', [
            'foreignKey' => 'branch_id',
            'joinType' => 'INNER'
        ]);
        $this->hasMany('Posts', [
            'foreignKey' => 'user_id'
        ]);
        
        /* upload user image */
        $this->addBehavior('Utils.Uploadable', [
            'photo' => [                                                    //field_name of form input
                   'field' => 'id',                                          //Any field from form (id=5)
                   'path' => '{ROOT}{DS}{WEBROOT}{DS}uploads{DS}',           // Set path to webroot
                   'fileName' => '{field}.{extension}'                       // File name with extension
                   ],
                ]
        );
     /*   $this->addBehavior('Utils.Uploadable', [
            'photo' => [
              'removeFileOnUpdate' => true
              ],
            ]
        );
          
        $this->addBehavior('Utils.Uploadable', [
            'photo' => [
              'removeFileOnDelete' => true
              ],
            ]
        );  
        */
        
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->requirePresence('username', 'create')
            ->notEmpty('username')
            ->add('username', 'unique', ['rule' => 'validateUnique', 'provider' => 'table']);

       $validator
            ->requirePresence('password', 'create')
            ->notEmpty('password');

       $validator
            ->requirePresence('firstname', 'create')
            ->notEmpty('firstname');

	   $validator
            ->requirePresence('lastname', 'create')
            ->notEmpty('lastname');

	$validator->add('email', 'valid-email', ['rule' => 'email']);

	  $validator
            ->add('contact', 'valid', ['rule' => 'numeric'])
            ->requirePresence('phoneno', 'create')
            ->notEmpty('phoneno');

        

        $validator
            ->requirePresence('gender', 'create')
            ->notEmpty('gender');

         $validator
            ->requirePresence('group_id', 'create')
            ->notEmpty('group_id');
        
     /*  $validator
            ->requirePresence('panno', 'create')
            ->notEmpty('panno')
            ->add('panno',['maxLength' => array(
                'rule' => array('maxLength', 10),
                'message' => '10 digit no'
                ), 
                'minLength' => array(
                'rule' => array('minLength', 10),
                'message' => '10 digit Number'
            )]);
        */    

        return $validator;
    }



    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->isUnique(['username']));
        $rules->add($rules->existsIn(['group_id'], 'Groups'));

        return $rules;
    }
    
    public function beforeSave(\Cake\Event\Event $event, \Cake\ORM\Entity $entity, 
    \ArrayObject $options) {
            $hasher = new DefaultPasswordHasher;
            $entity->password = $hasher->hash($entity->password);
            return true;
    }

    

        
}
