<?php
namespace App\Controller;

use App\Controller\AppController;

/**
 * Mffunds Controller
 *
 * @property \App\Model\Table\MffundsTable $Mffunds
 */
class MffundsController extends AppController
{

    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index()
    {
      $this->Search->addFilter('company', [
        'attributes'=>['placeholder'=>'Company Name','label'=>'Company Name :','class'=>'searchfrm',],  
        'options' => $this->Mffunds->Companies->find('list')->  where(['associatewith' => 'product'])->andWhere(['Companies.productid ='=>'1'] )->order(['company' => 'ASC'])->toArray(),
      ]);
        $this->paginate = [
            'contain' => ['Companies']
        ];
        $query = '';
        if (!empty($this->request->query['company']) && $this->request->query['company'] !='' && $this->request->query['company'] != 'null') { 
            $query = (($this->request->query['company'] !='')? $this->request->query['company'] : '');
           
            if ($query !=''){ 
                $conditions['conditions']['or']['Mffunds.company_id'] = "$query";
                $mffunds = $this->Mffunds->find('all', $conditions);
             }else{
                $mffunds = $this->mffunds;
             }    

            $mffunds = $this->paginate($mffunds,['order' =>['Mffunds.fundname'=>'ASC']]);
            $this->set(compact('mffunds'));
            $this->set('_serialize', ['mffunds']);
       
      }else{
          
        $mffunds = $this->paginate($this->Mffunds,['order' =>['Mffunds.fundname'=>'ASC']]);
        $this->set(compact('mffunds'));
        $this->set('_serialize', ['mffunds']);
      }
    }

    /**
     * View method
     *
     * @param string|null $id Mffund id.
     * @return \Cake\Network\Response|null
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $mffund = $this->Mffunds->get($id, [
            'contain' => ['Companies']
        ]);

        $this->set('mffund', $mffund);
        $this->set('_serialize', ['mffund']);
    }

    /**
     * Add method
     *
     * @return \Cake\Network\Response|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $mffund = $this->Mffunds->newEntity();
        if ($this->request->is('post')) {
            $mffund = $this->Mffunds->patchEntity($mffund, $this->request->data);
			$is_exists = $this->Mffunds->find('list')->where(['Mffunds.fundname'=>$mffund->fundname])->andWhere(['Mffunds.company_id'=>$mffund->company_id] )->count();
			//$number = $is_exists->count();
				//pr($number);
				//pr($is_exists->toArray());
				//die();
			if($is_exists>0)
			{
			$this->Flash->error(__('already exists'));
			}
			else{
            if ($this->Mffunds->save($mffund)) {
			
			
                $this->Flash->success(__('The mffund has been saved.'));

                return $this->redirect(['action' => 'index']);
            } 
			else {
                $this->Flash->error(__('The mffund could not be saved. Please, try again.'));
            
			}
			}
        }
       
        $companies = $this->Mffunds->Companies->find('list')->  where(['associatewith' => 'product'])->andWhere(['Companies.productid ='=>'1'] )->order(['company' => 'ASC'])->order(['company' => 'ASC']);
        $this->set(compact('mffund', 'companies'));
        $this->set('_serialize', ['mffund']);
    }

    /**
     * Edit method
     *
     * @param string|null $id Mffund id.
     * @return \Cake\Network\Response|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $mffund = $this->Mffunds->get($id, [
            'contain' => []
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $mffund = $this->Mffunds->patchEntity($mffund, $this->request->data);
            if ($this->Mffunds->save($mffund)) {
                $this->Flash->success(__('The mffund has been saved.'));

                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The mffund could not be saved. Please, try again.'));
            }
        }
        $companies = $this->Mffunds->Companies->find('list')-> where(['associatewith' => 'product'])->order(['company' => 'ASC']);
        $this->set(compact('mffund', 'companies'));
        $this->set('_serialize', ['mffund']);
    }

    /**
     * Delete method
     *
     * @param string|null $id Mffund id.
     * @return \Cake\Network\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $mffund = $this->Mffunds->get($id);
        if ($this->Mffunds->delete($mffund)) {
            $this->Flash->success(__('The mffund has been deleted.'));
        } else {
            $this->Flash->error(__('The mffund could not be deleted. Please, try again.'));
        }

        return $this->redirect(['action' => 'index']);
    }
}
