<?php
namespace App\Controller;

use App\Controller\AppController;
use Cake\ORM\TableRegistry;
/**
 * Customers Controller
 *
 * @property \App\Model\Table\CustomersTable $Customers
 */
class CustomersController extends AppController
{

    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index()
    {
         
         $all = array('all'=>'All');
         /*$this->Search->addFilter('firstname', [
        'attributes'=>['placeholder'=>'Customer Name','label'=>'Customer Name :','class'=>'searchfrm','value'=>isset($this->request->query['firstname'])?$this->request->query['firstname']:''],  
        'options' => $all+$this->Customers->find('list',['keyField'=>'firstname','valueField'=>'firstname'])->order(['firstname' => 'ASC'])->toArray(),
      ]); */
      
        $this->Search->addFilter('firstname',['attributes'=>['placeholder'=>'Customer Name :','label'=>'Customer Name :','class'=>'serachfrm serachfrm_clearable','id'=>'autocomplete1','value'=>isset($this->request->query['firstname'])?$this->request->query['firstname']:''],]);
        $custname = $this->Customers->find('list',['valueField'=>'firstname'])->order(['firstname' => 'ASC'])->group(['Customers.firstname'])->toArray();
        $custname = array_values($custname);
        
      $this->Search->addFilter('cpanno',['attributes'=>['placeholder'=>'Pan No','label'=>'Pan No','class'=>'searchfrm','value'=>isset($this->request->query['cpanno'])?$this->request->query['cpanno']:''],]);
      /*  $this->paginate = [
            'contain' => [ 'Companies', 'Branches']
        ];
        */
        $conditions = '';  
		$group=$this->paginate['group'] = array('Customers.panno','Customers.firstname');
        if (!empty($this->request->query)) { 
            $panno = (($this->request->query['cpanno'] != '')? $this->request->query['cpanno'] : '');
			if ($panno!=''){ $conditions['conditions']['or']['Customers.panno'] = "$panno"; }
	         $firstname = $this->request->query['firstname']; 
	  if ($firstname && $firstname != 'all'){ $conditions['conditions']['or']['firstname LIKE'] = "%$firstname%"; }
	  
	  
	  
	  
      if ( ($firstname != '' && $firstname != 'all') || $panno!='' ) {
               $customers = $this->Customers->find('all', $conditions);

			    $customers = $this->paginate($customers);
            }else{
               $customers = $this->Customers;
			    $customers = $this->paginate($customers,['order' =>['Customers.firstname'=>'ASC']]);
            }  
			
		//$this->set(compact('customers'));
        //$this->set('_serialize', ['customers']);			
}			
      else
	  {
	  
        $customers = $this->paginate($this->Customers,['order' =>['Customers.firstname'=>'ASC']]);

        //$this->set(compact('customers'));
        //$this->set('_serialize', ['customers']);
	  
	  }
	  $this->set(compact('customers','custname'));
    }

    /**
     * View method
     *
     * @param string|null $id Customer id.
     * @return \Cake\Network\Response|null
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {   //'Companies', 'Branches'
       $customer = $this->Customers->get($id, [
            'contain' => []
        ]);
     
        $this->set('customer', $customer);
        $this->set('_serialize', ['customer']);
    }

    /**
     * Add method
     *
     * @return \Cake\Network\Response|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $customer = $this->Customers->newEntity();
        if ($this->request->is('post')) {
			
			$this->request->data['firstname'] = trim($this->request->data['firstname']);
			$this->request->data['panno'] = trim($this->request->data['panno']);
			
            $customer = $this->Customers->patchEntity($customer, $this->request->data);
            
             /* insert account no */
            $query = $this->Customers->find('all', [
                'order' => ['Customers.created' => 'DESC']
            ]);
            
             $lastuid = $query->first()->id;  
           
            $accountNo = (1000 + ($lastuid + 1));
            $customer->accountno = $accountNo;
            
            if ($this->Customers->save($customer)) {
                $this->Flash->success(__('The customer has been saved.'));

                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The customer could not be saved. Please, try again.'));
            }
        }
       // $groups = $this->Customers->Groups->find('list', ['limit' => 200]);
        $companies = $this->Customers->Companies->find('list', ['limit' => 200])->order(['company' => 'ASC']);
        $branches = $this->Customers->Branches->find('list', ['limit' => 200])->order(['branchname' => 'ASC']);
        $gender  = array('male'=>'Male','female'=>'Female');
        $this->set(compact('customer',  'companies', 'branches','gender'));
        $this->set('_serialize', ['customer']);
    }

    /**
     * Edit method
     *
     * @param string|null $id Customer id.
     * @return \Cake\Network\Response|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $customer = $this->Customers->get($id, [
            'contain' => []
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
			
			$this->request->data['firstname'] = trim($this->request->data['firstname']);
			$this->request->data['panno'] = trim($this->request->data['panno']);
			
            $customer = $this->Customers->patchEntity($customer, $this->request->data);
            if ($this->Customers->save($customer)) {
                $this->Flash->success(__('The customer has been saved.'));

                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The customer could not be saved. Please, try again.'));
            }
        }
        //$groups = $this->Customers->Groups->find('list', ['limit' => 200]);
        $companies = $this->Customers->Companies->find('list', ['limit' => 200])->order(['company' => 'ASC']);
        $branches = $this->Customers->Branches->find('list', ['limit' => 200])->order(['branchname' => 'ASC']);
        $gender  = array('male'=>'Male','female'=>'Female');
        $this->set(compact('customer', 'companies', 'branches','gender'));
        $this->set('_serialize', ['customer']);
    }    

    /**
     * Delete method
     *
     * @param string|null $id Customer id.
     * @return \Cake\Network\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $customer = $this->Customers->get($id);
        if ($this->Customers->delete($customer)) {
            $this->Flash->success(__('The customer has been deleted.'));
        } else {
            $this->Flash->error(__('The customer could not be deleted. Please, try again.'));
        }

        return $this->redirect(['action' => 'index']);
    }
}
