<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * FdSubBrokeragePayments Model
 *
 * @property \Cake\ORM\Association\BelongsTo $Fds
 * @property \Cake\ORM\Association\BelongsTo $SubBrokeragePayments
 *
 * @method \App\Model\Entity\FdSubBrokeragePayment get($primaryKey, $options = [])
 * @method \App\Model\Entity\FdSubBrokeragePayment newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\FdSubBrokeragePayment[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\FdSubBrokeragePayment|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\FdSubBrokeragePayment patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\FdSubBrokeragePayment[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\FdSubBrokeragePayment findOrCreate($search, callable $callback = null)
 */
class FdSubBrokeragePaymentsTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('fd_sub_brokerage_payments');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->belongsTo('Fds', [
            'foreignKey' => 'fd_id'
        ]);
        $this->belongsTo('SubBrokeragePayments', [
            'foreignKey' => 'sub_brokerage_payment_id'
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->decimal('percentage')
            ->allowEmpty('percentage');

        $validator
            ->decimal('sub_brokerage_amount')
            ->allowEmpty('sub_brokerage_amount');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['fd_id'], 'Fds'));
        $rules->add($rules->existsIn(['sub_brokerage_payment_id'], 'SubBrokeragePayments'));

        return $rules;
    }
}
