<?php

namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;
use Cake\I18n\FrozenTime;

class AuditsTable extends Table {
	
	
	/**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('audits');
        $this->displayField('id');
        $this->primaryKey('id');

      
        $this->belongsTo('Users', [
            'foreignKey' => 'user_id',
            'joinType' => 'LEFT'
        ]);
        
    }

    public function saveDeletedData($model_id,$model,$user_id,$deleted_content,$updated_content,$controller,$action,$status = 0){ 
		//pr($user_id);
        $currentDate = FrozenTime::now();
        if($user_id){
                $auditData = $this->newEntity([
                'model' => $model,
                'model_id' => $model_id,
                'user_id' => $user_id,
                'updated_date' => $currentDate,
                'deleted_content' => $deleted_content,
                'updated_content' => $updated_content,
                'controller' => $controller,
                'action' => $action,
                'ip' => $_SERVER['REMOTE_ADDR'],
                'status' => $status
            ]);
            //pr($auditData);
		
        	$this->save($auditData);
		}
	}
	

}