<?php
namespace App\Controller;
use App\Controller\AppController;
use Cake\ORM\TableRegistry;
use Cake\Event\Event;
use Cake\Network\Exception;

/**
 * Regionalmanagers Controller
 *
 * @property \App\Model\Table\RegionalmanagersTable $Regionalmanagers
 */
class RegionalmanagersController extends AppController
{

    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index()
    {
		$regionalmanagers = $this->Regionalmanagers->find('all')->contain('Branches');
		$this->paginate = [
            'contain' => ['Branches']
        ];
		$regionalmanagers = $this->paginate($regionalmanagers,['order' => ['Regionalmanagers.manager' => 'ASC']]);
        $this->set(compact('regionalmanagers'));
        $this->set('_serialize', ['regionalmanagers']);
    }

    /**
     * View method
     *
     * @param string|null $id Regionalmanager id.
     * @return \Cake\Network\Response|null
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $regionalmanager = $this->Regionalmanagers->get($id, [
            'contain' => []
        ]);

        $this->set('regionalmanager', $regionalmanager);
        $this->set('_serialize', ['regionalmanager']);
    }

    /**
     * Add method
     *
     * @return \Cake\Network\Response|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $regionalmanager = $this->Regionalmanagers->newEntity();
        if ($this->request->is('post')) {
            $regionalmanager = $this->Regionalmanagers->patchEntity($regionalmanager, $this->request->data);
            if ($this->Regionalmanagers->save($regionalmanager)) {
                $this->Flash->success(__('The regionalmanager has been saved.'));

                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The regionalmanager could not be saved. Please, try again.'));
            }
        }
		$branch = $this->Regionalmanagers->Branches->find('list', ['keyField' => 'id', 'valueField' => 'branchname']);
		
        $this->set(compact('regionalmanager','branch'));
        $this->set('_serialize', ['regionalmanager']);
    }

    /**
     * Edit method
     *
     * @param string|null $id Regionalmanager id.
     * @return \Cake\Network\Response|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $regionalmanager = $this->Regionalmanagers->get($id, [
            'contain' => []
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $regionalmanager = $this->Regionalmanagers->patchEntity($regionalmanager, $this->request->data);
            if ($this->Regionalmanagers->save($regionalmanager)) {
                $this->Flash->success(__('The regionalmanager has been saved.'));

                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The regionalmanager could not be saved. Please, try again.'));
            }
        }
		$branch = $this->Regionalmanagers->Branches->find('list', ['keyField' => 'id', 'valueField' => 'branchname']);
        $this->set(compact('regionalmanager','branch'));
        $this->set('_serialize', ['regionalmanager']);
    }

    /**
     * Delete method
     *
     * @param string|null $id Regionalmanager id.
     * @return \Cake\Network\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $regionalmanager = $this->Regionalmanagers->get($id);
        if ($this->Regionalmanagers->delete($regionalmanager)) {
            $this->Flash->success(__('The regionalmanager has been deleted.'));
        } else {
            $this->Flash->error(__('The regionalmanager could not be deleted. Please, try again.'));
        }

        return $this->redirect(['action' => 'index']);
    }
}
