<?php
namespace App\Controller;

use App\Controller\AppController;
use Cake\ORM\TableRegistry;
/**
 * Companies Controller
 *
 * @property \App\Model\Table\CompaniesTable $Companies
 */
class CompaniesController extends AppController
{

    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index()
    {
        $conditions = array();
        $all = array('all'=>'All');

        $this->Search->addFilter('company', [
        'attributes'=>['placeholder'=>'Company Name','label'=>'Company Name :','class'=>'searchfrm',],  
        'options' => $all+$this->Companies->find('list')->order(['company' => 'ASC'])->toArray(),
        ]);

        if (!empty($this->request->query['company']) && $this->request->query['company'] != 'all') {
            $conditions['id'] = $this->request->query['company'];
        }
        
        $companies = $this->paginate($this->Companies,['conditions' => $conditions,'order' =>['Companies.company'=>'ASC']]);

        $this->set(compact('companies'));
        $this->set('_serialize', ['companies']);
    }

    /**
     * View method
     *
     * @param string|null $id Company id.
     * @return \Cake\Network\Response|null
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $company = $this->Companies->get($id, [
            'contain' => []
        ]);

        $this->set('company', $company);
        $this->set('_serialize', ['company']);
    }

    /**
     * Add method
     *
     * @return \Cake\Network\Response|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $company = $this->Companies->newEntity();
        if ($this->request->is('post')) {
            if(!empty($this->request->data['productid'])){
            $this->request->data['productid'] = implode(",",$this->request->data['productid']);
            }
            $company = $this->Companies->patchEntity($company, $this->request->data);            
            if ($this->Companies->save($company)) {
                $this->Flash->success(__('The company has been saved.'));

                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The company could not be saved. Please, try again.'));
            }
        }
        $products = TableRegistry::get('Products'); 
	$productlists = $products->find('list');
	$productlists = $productlists->toArray();		
        $this->set(compact('company','productlists'));        
        $this->set('_serialize', ['company']);
    }

    /**
     * Edit method
     *
     * @param string|null $id Company id.
     * @return \Cake\Network\Response|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $company = $this->Companies->get($id, [
            'contain' => []
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
        $this->request->data['productid'] = implode(",",$this->request->data['productid']);
            $company = $this->Companies->patchEntity($company, $this->request->data);
            if ($this->Companies->save($company)) {
                $this->Flash->success(__('The company has been saved.'));
                
                
                /*--Check Fds table if exist and Sync Institution Name on mtables*/
                $this->LoadModel("Fds");
                $this->LoadModel("Mtables");
                $productcompanies = $this->Fds->Companies->find('list')-> where(['associatewith' => 'product'])->where(['productid LIKE' => '%2%'])->order(['company' => 'ASC'])->toArray();
                //pr($productcompanies);exit;

                $isfd_exists = $this->Fds->find('list', [
                    'keyField' => 'id',
                    'valueField' => 'id'
                ])-> where(['Fds.productcompanyid'=>$id]);



                if ($isfd_exists->count() > 0){
                    $fdtable_fdids =  $isfd_exists->toArray();
                    $institution_name = !empty($productcompanies[$id]) ? $productcompanies[$id] : '' ;

                    $this->Mtables->updateAll(
                        ["institution_name" => $institution_name],
                        ["fdtable_fdid IN" => $fdtable_fdids]
                    );

                }
                /*--Check Fds table if exist and Sync Institution Name on mtables End*/

                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The company could not be saved. Please, try again.'));
            }
        }
        $products = TableRegistry::get('Products'); 
	$productlists = $products->find('list');
	$productlists = $productlists->toArray();		
        $this->set(compact('company','productlists'));
        $this->set('_serialize', ['company']);
    }

    /**
     * Delete method
     *
     * @param string|null $id Company id.
     * @return \Cake\Network\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $company = $this->Companies->get($id);
        if ($this->Companies->delete($company)) {
            $this->Flash->success(__('The company has been deleted.'));
        } else {
            $this->Flash->error(__('The company could not be deleted. Please, try again.'));
        }

        return $this->redirect(['action' => 'index']);
    }
}
