<?php
namespace App\Controller;

use App\Controller\AppController;

/**
 * Bankbranchs Controller
 *
 * @property \App\Model\Table\BankbranchsTable $Bankbranchs
 */
class BankbranchesController extends AppController
{

    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index()
    {
        $this->paginate = [
            'contain' => ['Banks']
        ];
        $bankbranchs = $this->paginate($this->Bankbranches,['order' =>['Bankbranches.branchaddress'=>'ASC']]);

        $this->set(compact('bankbranchs'));
        $this->set('_serialize', ['bankbranchs']);
    }

    /**
     * View method
     *
     * @param string|null $id Bankbranch id.
     * @return \Cake\Network\Response|null
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $bankbranch = $this->Bankbranches->get($id, [
            'contain' => ['Banks']
        ]);

        $this->set('bankbranch', $bankbranch);
        $this->set('_serialize', ['bankbranch']);
    }

    /**
     * Add method
     *
     * @return \Cake\Network\Response|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $bankbranch = $this->Bankbranches->newEntity();
        if ($this->request->is('post')) {
            $bankbranch = $this->Bankbranches->patchEntity($bankbranch, $this->request->data);
            if ($this->Bankbranches->save($bankbranch)) {
                $this->Flash->success(__('The bankbranch has been saved.'));

                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The bankbranch could not be saved. Please, try again.'));
            }
        }
        $banks = $this->Bankbranches->Banks->find('list')->order(['banks' => 'ASC']);
        $this->set(compact('bankbranch', 'banks'));
        $this->set('_serialize', ['bankbranch']);
    }

    /**
     * Edit method
     *
     * @param string|null $id Bankbranch id.
     * @return \Cake\Network\Response|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $bankbranch = $this->Bankbranches->get($id, [
            'contain' => []
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $bankbranch = $this->Bankbranches->patchEntity($bankbranch, $this->request->data);
            if ($this->Bankbranches->save($bankbranch)) {
                $this->Flash->success(__('The bankbranch has been saved.'));

                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The bankbranch could not be saved. Please, try again.'));
            }
        }
        $banks = $this->Bankbranches->Banks->find('list', ['limit' => 200])->order(['banks' => 'ASC']);
        $this->set(compact('bankbranch', 'banks'));
        $this->set('_serialize', ['bankbranch']);
    }

    /**
     * Delete method
     *
     * @param string|null $id Bankbranch id.
     * @return \Cake\Network\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $bankbranch = $this->Bankbranches->get($id);
        if ($this->Bankbranches->delete($bankbranch)) {
            $this->Flash->success(__('The bankbranch has been deleted.'));
        } else {
            $this->Flash->error(__('The bankbranch could not be deleted. Please, try again.'));
        }

        return $this->redirect(['action' => 'index']);
    }
}
