<?php
namespace App\Controller;

use App\Controller\AppController;

/**
 * Subbrokers Controller
 *
 * @property \App\Model\Table\SubbrokersTable $Subbrokers
 */
class BrokersController extends AppController
{

    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index()
    {
        $brokers = $this->paginate($this->Brokers,['order' =>['Brokers.name'=>'ASC']]);

        $this->set(compact('brokers'));
        $this->set('_serialize', ['brokers']);
    }

    /**
     * View method
     *
     * @param string|null $id Subbroker id.
     * @return \Cake\Network\Response|null
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $broker = $this->Brokers->get($id, [
            'contain' => []
        ]);

        $this->set('broker', $broker);
        $this->set('_serialize', ['broker']);
    }

    /**
     * Add method
     *
     * @return \Cake\Network\Response|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $broker = $this->Brokers->newEntity();
        if ($this->request->is('post')) {
            $broker = $this->Brokers->patchEntity($broker, $this->request->data);
            if ($this->Brokers->save($broker)) {
                $this->Flash->success(__('The broker has been saved.'));

                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The broker could not be saved. Please, try again.'));
            }
        }
         $role = array(
            'Subbroker'=> 'Subbroker',
            'Mainbroker'=> 'Main Broker'
        );
        $this->set(compact('broker','role'));
        $this->set('_serialize', ['broker']);
    }

    /**
     * Edit method
     *
     * @param string|null $id Subbroker id.
     * @return \Cake\Network\Response|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $broker = $this->Brokers->get($id, [
            'contain' => []
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $broker = $this->Brokers->patchEntity($broker, $this->request->data);
            if ($this->Brokers->save($broker)) {
                $this->Flash->success(__('The broker has been saved.'));

                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The broker could not be saved. Please, try again.'));
            }
        }
        $role = array(
            'Subbroker'=> 'Subbroker',
            'Mainbroker'=> 'Main Broker'
        );
        $this->set(compact('broker','role'));
        $this->set('_serialize', ['broker']);
    }

    /**
     * Delete method
     *
     * @param string|null $id Subbroker id.
     * @return \Cake\Network\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $broker = $this->Brokers->get($id);
        if ($this->Brokers->delete($broker)) {
            $this->Flash->success(__('The broker has been deleted.'));
        } else {
            $this->Flash->error(__('The broker could not be deleted. Please, try again.'));
        }

        return $this->redirect(['action' => 'index']);
    }
}
