<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Ncds Model
 *
 * @property \Cake\ORM\Association\BelongsTo $Users
 * @property \Cake\ORM\Association\BelongsTo $Companies
 * @property \Cake\ORM\Association\BelongsTo $Branches
 * @property \Cake\ORM\Association\BelongsTo $Banks
 * @property \Cake\ORM\Association\BelongsTo $Bankdetails
 * @property \Cake\ORM\Association\HasMany $Searies
 *
 * @method \App\Model\Entity\Ncd get($primaryKey, $options = [])
 * @method \App\Model\Entity\Ncd newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Ncd[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Ncd|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Ncd patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Ncd[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Ncd findOrCreate($search, callable $callback = null)
 */
class NcdsTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('ncds');
        $this->displayField('applicationno');
        $this->primaryKey('id');

        $this->belongsTo('Brokers', [
            'foreignKey' => 'broker_id',
            'joinType' => 'INNER'
        ]);
        $this->belongsTo('Customers', [
            'foreignKey' => 'customer_id',
            'joinType' => 'INNER'
        ]);
        $this->belongsTo('Companies', [
            'foreignKey' => 'company_id',
            'joinType' => 'INNER'
        ]);
        $this->belongsTo('Branches', [
            'foreignKey' => 'branch_id',
            'joinType' => 'INNER'
        ]);
        $this->belongsTo('Banks', [
            'foreignKey' => 'bank_id',
            'joinType' => 'INNER'
        ]);
        $this->belongsTo('Plans', [
            'foreignKey' => 'plan_id',
            'joinType' => 'INNER'
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->integer('productcompanyid')
            ->requirePresence('productcompanyid', 'create')
            ->notEmpty('productcompanyid');
        $validator
            ->requirePresence('typeofdeposit', 'create')
            ->notEmpty('typeofdeposit');        
      
        $validator
            ->requirePresence('tenure', 'create')
            ->notEmpty('tenure');
        $validator
            ->requirePresence('firstapplicantname', 'create')
            ->notEmpty('firstapplicantname');

        $validator
            ->requirePresence('amount', 'create')
            ->notEmpty('amount');
	/*
        $validator
            ->integer('chequeno')
            ->requirePresence('chequeno', 'create')
            ->notEmpty('chequeno');
          */
        $validator
            ->requirePresence('despatchdate', 'create')
            ->notEmpty('despatchdate');
       
        $validator
            ->requirePresence('panno', 'create')
            ->notEmpty('panno');

      /*  $validator
            ->requirePresence('branch_id', 'create')
            ->notEmpty('branch_id');
       * 
       */
        $validator
            ->requirePresence('company_id', 'create')
            ->notEmpty('company_id');
       /* $validator
            ->requirePresence('bank_id', 'create')
            ->notEmpty('bank_id');
        $validator
            ->requirePresence('plan_id', 'create')
            ->notEmpty('plan_id');*/
        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['customer_id'], 'Customers'));
        $rules->add($rules->existsIn(['company_id'], 'Companies'));
        $rules->add($rules->existsIn(['branch_id'], 'Branches'));
        //$rules->add($rules->existsIn(['bank_id'], 'Banks'));
        $rules->add($rules->existsIn(['broker_id'], 'Brokers'));
      //  $rules->add($rules->existsIn(['plan_id'], 'Plans'));
        return $rules;
    }
}
