<nav class="large-3 medium-4 columns" id="actions-sidebar">
    <ul class="side-nav">
        <li class="heading"><?= __('Actions') ?></li>
        <li><?= $this->Html->link(__('New Subbroker'), ['action' => 'add']) ?></li>
        <li><?= $this->Html->link(__('List Fds'), ['controller' => 'Fds', 'action' => 'index']) ?></li>
        <li><?= $this->Html->link(__('New Fd'), ['controller' => 'Fds', 'action' => 'add']) ?></li>
        <li><?= $this->Html->link(__('List Investments'), ['controller' => 'Investments', 'action' => 'index']) ?></li>
        <li><?= $this->Html->link(__('New Investment'), ['controller' => 'Investments', 'action' => 'add']) ?></li>
    </ul>
</nav>
<div class="subbrokers index large-9 medium-8 columns content">
    <h3><?= __('Subbrokers') ?></h3>
    <table cellpadding="0" cellspacing="0">
        <thead>
            <tr>
                <th scope="col"><?= $this->Paginator->sort('id') ?></th>
                <th scope="col"><?= $this->Paginator->sort('subbroker') ?></th>
                <th scope="col" class="actions"><?= __('Actions') ?></th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($subbrokers as $subbroker): ?>
            <tr>
                <td><?= $this->Number->format($subbroker->id) ?></td>
                <td><?= h($subbroker->subbroker) ?></td>
                <td class="actions">
                    <?= $this->Html->link(__('View'), ['action' => 'view', $subbroker->id]) ?>
                    <?= $this->Html->link(__('Edit'), ['action' => 'edit', $subbroker->id]) ?>
                    <!--<?= $this->Form->postLink(__('Delete'), ['action' => 'delete', $subbroker->id], ['confirm' => __('Are you sure you want to delete # {0}?', $subbroker->id)]) ?>-->
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    <div class="paginator">
        <ul class="pagination">
            <?= $this->Paginator->prev('< ' . __('previous')) ?>
            <?= $this->Paginator->numbers() ?>
            <?= $this->Paginator->next(__('next') . ' >') ?>
        </ul>
        <p><?= $this->Paginator->counter() ?></p>
    </div>
</div>
