<nav class="large-3 medium-4 columns" id="actions-sidebar">
    <ul class="side-nav">
        <li class="heading"><?= __('Actions') ?></li>
        <li><?= $this->Html->link(__('New Investment'), ['action' => 'add']) ?></li>
        <li><?= $this->Html->link(__('List Customers'), ['controller' => 'Customers', 'action' => 'index']) ?></li>
        <li><?= $this->Html->link(__('New Customer'), ['controller' => 'Customers', 'action' => 'add']) ?></li>
        <li><?= $this->Html->link(__('List Products'), ['controller' => 'Products', 'action' => 'index']) ?></li>
        <li><?= $this->Html->link(__('New Product'), ['controller' => 'Products', 'action' => 'add']) ?></li>
        <li><?= $this->Html->link(__('List Mffunds'), ['controller' => 'Mffunds', 'action' => 'index']) ?></li>
        <li><?= $this->Html->link(__('New Mffund'), ['controller' => 'Mffunds', 'action' => 'add']) ?></li>
        <li><?= $this->Html->link(__('List Plans'), ['controller' => 'Plans', 'action' => 'index']) ?></li>
        <li><?= $this->Html->link(__('New Plan'), ['controller' => 'Plans', 'action' => 'add']) ?></li>
        <li><?= $this->Html->link(__('List Banks'), ['controller' => 'Banks', 'action' => 'index']) ?></li>
        <li><?= $this->Html->link(__('New Bank'), ['controller' => 'Banks', 'action' => 'add']) ?></li>
    </ul>
</nav>
<div class="investments index large-9 medium-8 columns content">
    <h3><?= __('Investments') ?></h3>
    <table cellpadding="0" cellspacing="0">
        <thead>
            <tr>
                <th scope="col"><?= $this->Paginator->sort('id') ?></th>
                <th scope="col"><?= $this->Paginator->sort('mutualfund_id') ?></th>
                <th scope="col"><?= $this->Paginator->sort('customer_id') ?></th>
                <th scope="col"><?= $this->Paginator->sort('product_id') ?></th>
                <th scope="col"><?= $this->Paginator->sort('mffund_id') ?></th>                
                <th scope="col"><?= $this->Paginator->sort('amountinvested') ?></th>
                <th scope="col"><?= $this->Paginator->sort('netamountpaid') ?></th>
                <th scope="col"><?= $this->Paginator->sort('chequeDDNo') ?></th>
                <th scope="col"><?= $this->Paginator->sort('bank_id') ?></th>
                <th scope="col"><?= $this->Paginator->sort('bankACNo') ?></th>
                <th scope="col"><?= $this->Paginator->sort('bankbranch_id') ?></th>
                <th scope="col" class="actions"><?= __('Actions') ?></th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($investments as $investment): ?>
            <tr>
                <td><?= $this->Number->format($investment->id) ?></td>
                <td><?= $investment->has('mutualfund') ? $this->Html->link($investment->mutualfund->applicationno, ['controller' => 'Mutualfunds', 'action' => 'view', $investment->mutualfund->id]) : '' ?></td>               
                <td><?= $investment->has('customer') ? $this->Html->link($investment->customer->accountno, ['controller' => 'Customers', 'action' => 'view', $investment->customer->id]) : '' ?></td>
                <td><?= $investment->has('product') ? $this->Html->link($investment->product->productname, ['controller' => 'Products', 'action' => 'view', $investment->product->id]) : '' ?></td>
                <td><?= $investment->has('mffund') ? $this->Html->link($investment->mffund->fundname, ['controller' => 'Mffunds', 'action' => 'view', $investment->mffund->id]) : '' ?></td>
                <td><?= $this->Number->format($investment->amountinvested) ?></td>
                <td><?= $this->Number->format($investment->netamountpaid) ?></td>
                <td><?= h($investment->chequeDDNo) ?></td>
                <td><?= $investment->has('bank') ? $this->Html->link($investment->bank->banks, ['controller' => 'Banks', 'action' => 'view', $investment->bank->id]) : '' ?></td>
                <td><?= h($investment->bankACNo) ?></td>
                <td><?= $this->Number->format($investment->bankbranch_id) ?></td>
                <td class="actions">
                    <?= $this->Html->link(__('View'), ['action' => 'view', $investment->id]) ?>
                    <?= $this->Html->link(__('Edit'), ['action' => 'edit', $investment->id]) ?>
                    <!--<?= $this->Form->postLink(__('Delete'), ['action' => 'delete', $investment->id], ['confirm' => __('Are you sure you want to delete # {0}?', $investment->id)]) ?>-->
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    <div class="paginator">
        <ul class="pagination">
            <?= $this->Paginator->prev('< ' . __('previous')) ?>
            <?= $this->Paginator->numbers() ?>
            <?= $this->Paginator->next(__('next') . ' >') ?>
        </ul>
        <p><?= $this->Paginator->counter() ?></p>
    </div>
</div>
