<?php
namespace App\Controller;

use App\Controller\AppController;

/**
 * Plans Controller
 *
 * @property \App\Model\Table\PlansTable $Plans
 */
class PlansController extends AppController
{

    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index()
    {
       
              $this->Search->addFilter('productname', [
        'attributes'=>['placeholder'=>'Product Name','label'=>'Product Name :','class'=>'searchfrm',],  
        'options' =>  $this->Plans->Products->find('list')-> where(['Products.productname !=' => 'Mutual Fund'])->order(['productname' => 'ASC'])->toArray(),
      ]);
        $this->paginate = [
            'contain' => ['Companies','Products']
        ];
       // $conditions= $this->Plans->find('all') ->where(['Products.productname !=' => 'Mutual Fund']);
		  if (!empty($this->request->query)) { 
         $query = $this->request->query['productname'];
		if ($query){ $conditions['conditions']['or']['Plans.product_id'] = "$query"; }
		if ($query !=''){ 
               $plans = $this->Plans->find('all', $conditions);
            }else{
               $plans = $this->Plans;
            }    
			
		 $plans = $this->paginate($plans);
            $this->set(compact('plans'));
            $this->set('_serialize', ['plans']);
       
      }else{
	  $plans= $this->Plans->find('all') ->where(['Products.productname !=' => 'Mutual Fund']);
        $plans = $this->paginate($plans,['order' => ['Plans.id' => 'DESC']]);

        $this->set(compact('plans'));
        $this->set('_serialize', ['plans']);
		}
    }

    /**
     * View method
     *
     * @param string|null $id Plan id.
     * @return \Cake\Network\Response|null
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $plan = $this->Plans->get($id, [
            'contain' => ['Companies','Products']
        ]);

        $this->set('plan', $plan);
        $this->set('_serialize', ['plan']);
    }

    /**
     * Add method
     *
     * @return \Cake\Network\Response|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $plan = $this->Plans->newEntity();
        if ($this->request->is('post')) {
            $plan = $this->Plans->patchEntity($plan, $this->request->data);
            if ($this->Plans->save($plan)) {
                $this->Flash->success(__('The plan has been saved.'));

                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The plan could not be saved. Please, try again.'));
            }
        }
        $products = $this->Plans->Products->find('list', ['limit' => 200])->where(['Products.productname !=' => 'Mutual Fund'])->order(['productname' => 'ASC']);
        $productcompanies = $this->Plans->Companies->find('list')-> where(['associatewith' => 'product'])->andWhere(['Companies.productid !='=>'1'] )->order(['company' => 'ASC']);
        $tenure = array('12'=>'12 Month','24'=>'24 Month','36'=>'36 Month','48'=>'48 Month','60'=>'60 Month','72'=>'72 Month');
        $interestmode = array('monthly'=>'Monthly','quartely'=>'Quartely','halfyearly'=>'Half Yearly','annual'=>'Annual');
        $scheme = array('normal'=>'NORMAL','senior'=>'SENIOR');
        $this->set(compact('plan', 'products', 'productcompanies','tenure','interestmode','scheme'));
        $this->set('_serialize', ['plan']);
    }

    /**
     * Edit method
     *
     * @param string|null $id Plan id.
     * @return \Cake\Network\Response|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $plan = $this->Plans->get($id, [
            'contain' => []
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $plan = $this->Plans->patchEntity($plan, $this->request->data);
            if ($this->Plans->save($plan)) {
                $this->Flash->success(__('The plan has been saved.'));

                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The plan could not be saved. Please, try again.'));
            }
        }
        $products = $this->Plans->Products->find('list', ['limit' => 200])->where(['Products.productname !=' => 'Mutual Fund'])->order(['productname' => 'ASC']);
        $productcompanies = $this->Plans->Companies->find('list')-> where(['associatewith' => 'product'])->order(['company' => 'ASC']);
        $tenure = array('12'=>'12 Month','24'=>'24 Month','36'=>'36 Month','48'=>'48 Month','60'=>'60 Month','72'=>'72 Month');
        $interestmode = array('monthly'=>'Monthly','quartely'=>'Quartely','halfyearly'=>'Half Yearly','annual'=>'Annual');
        $scheme = array('normal'=>'NORMAL','senior'=>'SENIOR');
        $this->set(compact('plan', 'products', 'productcompanies','tenure','interestmode','scheme'));
        $this->set('_serialize', ['plan']);
    }

    /**
     * Delete method
     *
     * @param string|null $id Plan id.
     * @return \Cake\Network\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $plan = $this->Plans->get($id);
        if ($this->Plans->delete($plan)) {
            $this->Flash->success(__('The plan has been deleted.'));
        } else {
            $this->Flash->error(__('The plan could not be deleted. Please, try again.'));
        }

        return $this->redirect(['action' => 'index']);
    }
}
