<?php
namespace App\Controller;
//use App\Controller\DateTime;
use App\Controller\AppController;
use Cake\ORM\TableRegistry;
use Cake\Datasource\ConnectionManager;
/**
 * Mutualfunds Controller
 *
 * @property \App\Model\Table\MutualfundsTable $Mutualfunds
 */
class MutualfundsController extends AppController
{
    public  $components = array('RequestHandler');    
    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index(){
	   $this->Search->addFilter('name', [
          'attributes'=>['placeholder'=>'Applicant Name','label'=>'Applicant Name :','class'=>'searchfrm','value' => isset($this->request->query['firstname'])?$this->request->query['firstname']:''], 'options' => $this->Mutualfunds->Customers->find('list',['keyField' => 'name','valueField' => 'tname'])->order(['Customers.name'=>'ASC'])->group(['Customers.name'])->toArray(),
       ]);
		$this->Search->addFilter('datedform', [
         'attributes'=>['placeholder'=>'Start Date','label'=>'Start Date :','class'=>'searchfrm','value' => isset($this->request->query['datedform'])?$this->request->query['datedform']:''],
        ]);
        $this->Search->addFilter('datedto', [
           'attributes'=>['placeholder'=>'End Date','label'=>'End Date :','class'=>'searchfrm','value' => isset($this->request->query['datedto'])?$this->request->query['datedto']:''],
        ]);
        $conditions = '';  
        if($this->Auth->user('group_id')=='3'){        
            $branch_id = $this->Auth->user('branch_id');     
            $conditions['conditions']['and']['Mutualfunds.posteduserbranchid'] = "$branch_id";
        }elseif($this->Auth->user('group_id')=='4' || $this->Auth->user('group_id')=='5' || $this->Auth->user('group_id')=='6' || $this->Auth->user('group_id')=='7'){ 
            $branch_id = $this->Auth->user('branch_id');    
            $userid = $this->Auth->user('id'); 
            $conditions['conditions']['and']['Mutualfunds.posteduserbranchid'] = "$branch_id";
            $conditions['conditions']['and']['Mutualfunds.postedby'] = "$userid";
        }
	//	if (!empty($this->request->query)) 
	 if((!empty($this->request->query['firstname']))||(!empty($this->request->query['datedform'])) ||(!empty($this->request->query['datedto']))){ 
        
        $fapplicantname = $this->request->query['firstname'];    
        $dated2 =  (($this->request->query['datedform'] != '')? $this->request->query['datedform'] : '');
		$date_from = explode('/',$dated2);
        $datedform  = implode('-', array_reverse($date_from));
	    $dated1= (($this->request->query['datedto']!='')? $this->request->query['datedto']:'');
	    $date_to = explode('/',$dated1);
        $datedto  = implode('-', array_reverse($date_to));
	
		 /* if ($datedform && $datedto){
                 $conditions = array(
                     'conditions' => array(
                     'and' => array(
                                     array('trim(Mutualfunds.maturitydate) >= ' => $datedform,
                                       'trim(Mutualfunds.maturitydate) <= ' => $datedto
                                      )
                         )));
            }*/
		if ($datedform && $datedto){
			if($datedform == $datedto){
                $adt = new \DateTime($datedto);
                $adt->modify('+1 day');
                $datedto = $adt->format('Y-m-d');        
            }
                $conditions = array(
				'conditions' => array(
				'and' => array(
                        array('Mutualfunds.created >= ' => $datedform,
                            'Mutualfunds.created <= ' => $datedto
                ))));
            } 
            if ($fapplicantname){ $conditions['conditions']['or']['Mutualfunds.firstapplicantname'] = "$fapplicantname"; }
            if (( $fapplicantname != '')  || ($datedform && $datedto)){ 
			        $mutualfunds = $this->Mutualfunds->find('all', $conditions);
					$cnt = $mutualfunds->count();              
					if($mutualfunds){
						$total_amount = 0;                   
						 foreach ($mutualfunds as $md){ 
							$total_amount += $md->amount;
						 }
					} 
            }else{
				if($conditions !=''){
				$mutualfunds = $this->Mutualfunds->find('all', $conditions);
					
				$cnt = $mutualfunds->count();              
					if($mutualfunds){
						$total_amount = 0;                   
						 foreach ($mutualfunds as $md){ 
							$total_amount += $md->amount;
						 }
					} 
				}else{
				 $mutualfunds = $this->Mutualfunds; 
				 $mf1=$this->Mutualfunds->find('all',array('contain' => ['Companies', 'Branches', 'Mffunds','Brokers']));
				$cnt = $mf1->count();              
					if($mf1){
					   $total_amount = 0;                   
						 foreach ($mf1 as $md){ 
								$total_amount += $md->amount;
						 }
					} 
				}
            }    
            $this->paginate = [
               'contain' => ['Companies']
            ]; 
			$mutualfunds = $this->paginate($mutualfunds ,['order' => ['Mutualfunds.firstapplicantname' => 'ASC']]);
            $this->set(compact('mutualfunds','total_amount','cnt'));
            $this->set('_serialize', ['mutualfunds']);
		}
		else{
        $this->paginate = [
            'contain' => ['Companies']
        ];
        $conditions['conditions']['or']['DATE(Mutualfunds.created) = '] = date('Y-m-d');
        $mutualfunds = $this->Mutualfunds->find('all', $conditions);
		
		$cnt = $mutualfunds->count();              
		if($mutualfunds){
			$total_amount = 0;                   
			 foreach ($mutualfunds as $md){ 
				$total_amount += $md->amount;
			 }
		} 
        $mutualfunds = $this->paginate($mutualfunds,['order' => ['Mutualfunds.firstapplicantname' => 'DESC']]);
        $this->set(compact('mutualfunds','total_amount','cnt'));
        $this->set('_serialize', ['mutualfunds']);
		}
    }
    /**
     * View method
     *
     * @param string|null $id Mutualfund id.
     * @return \Cake\Network\Response|null
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
     public function view($id = null)
    { 
       /* $mutualfund = $this->Mutualfunds->get($id, [
            'contain' => ['Companies', 'Branches','Brokers','Mffunds','Eunis','Banks']
        ]);*/
        $mutualfund = $this->Mutualfunds->get($id);
         $companies = TableRegistry::get('Companies'); 
       $mffunds = TableRegistry::get('Mffunds'); 
		$users = TableRegistry::get('Users'); 
		$brokers = TableRegistry::get('Brokers');
		$banks = TableRegistry::get('Banks');
		$branches = TableRegistry::get('Branches');
       // pr($mutualfund);
        if($mutualfund->company_id > 0){
            $companyid = $companies->find()->where(['id' => $mutualfund->company_id]);
            $data16 = $companyid->toArray();
            $companyName = $data16[0]->company;
       }else{
           $companyName = '';
       }    
            $this->set('companyName', $companyName);
        if($mutualfund->productcompanyid > 0){
            $productcompanyid = $companies->find()->where(['id' => $mutualfund->productcompanyid]);
            $data1 = $productcompanyid->toArray();
            $productcompanyName = $data1[0]->company;
       }else{
           $productcompanyName = '';
       }    
            $this->set('productcompanyName', $productcompanyName);
        if($mutualfund->mffund_id > 0){
            $mffund_id = $mffunds->find()->where(['id' => $mutualfund->mffund_id]);
            $data6 = $mffund_id->toArray();
            $mfName = $data6[0]->fundname;
       }else{
           $mfName = '';
       } 
       $this->set('mfName', $mfName);
       if($mutualfund->newmfid > 0){
            $newmfid = $mffunds->find()->where(['id' => $mutualfund->newmfid]);
            $data3 = $newmfid->toArray();
            $newmfName = $data3[0]->fundname;
       }else{
           $newmfName = '';
       } 
       $this->set('newmfName', $newmfName);
       
       if($mutualfund->newproductcompanyid > 0){
            $newproductcompanyid = $companies->find()->where(['id' => $mutualfund->newproductcompanyid]);
            $data2 = $newproductcompanyid->toArray();
            $newproductcompanyName = $data2[0]->company;
       }else{  
           $newproductcompanyName = '';
       }
       $this->set('newproductcompanyName', $newproductcompanyName);
        
       if($mutualfund->newstpfund > 0){
            $newstpfund = $companies->find()->where(['id' => $mutualfund->newstpfund]);
            $data4 = $newstpfund->toArray();
            $newstpfundName = $data4[0]->company;
       }else{  
           $newstpfundName = '';
       }  
       $this->set('newstpfundName', $newstpfundName);
       
       
       if($mutualfund->newstpscheme > 0){
            $newstpscheme = $mffunds->find()->where(['id' => $mutualfund->newstpscheme]);
            $data5 = $newstpscheme->toArray();
            $newstpschemeName = $data5[0]->fundname;
       }else{  
           $newstpschemeName = '';
       }     
       $this->set('newstpschemeName', $newstpschemeName); 
       if($mutualfund->postedby > 0){
            $postedby = $users->find()->where(['id' => $mutualfund->postedby]);
            $data11 = $postedby->toArray();
            $userName = $data11[0]->username;
       }else{
           $userName = '';
       }    
            $this->set('userName', $userName);
       if($mutualfund->broker_id > 0){
				$brokersdata = $brokers->find()->where(['id' => $mutualfund->broker_id])->andwhere(['role'=>'Subbroker']);
				$data12 = $brokersdata->toArray();
			    $brokername = $data12[0]->name;
				}else{
                    $brokername = '';				    
				}
				 $this->set('brokername', $brokername);
		if($mutualfund->bank_id > 0){
				$banksdata = $banks->find()->where(['id' => $mutualfund->bank_id]);
				$data13 = $banksdata->toArray();
			    $bankname = $data13[0]->banks;
				}else{
                    $bankname = '';				    
				}
				 $this->set('bankname', $bankname);
				 if($mutualfund->posteduserbranchid > 0){
				$posteduserbranchdata = $branches->find()->where(['id' => $mutualfund->posteduserbranchid]);
				$data14 = $posteduserbranchdata->toArray();
			    $posteduserbranch = $data14[0]->branchname;
				}else{
                    $posteduserbranch = '';				    
				}
				 $this->set('posteduserbranch', $posteduserbranch);
        $this->set('mutualfund', $mutualfund);
        $this->set('_serialize', ['mutualfund']);
    }

    /**
     * Add method
     *
     * @return \Cake\Network\Response|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
       
         if ($this->request->is('ajax','get')) {         
            $terms = $this->Mutualfunds->Customers->find('all', [
                'conditions' => array('Customers.firstname LIKE ' => '%' . $this->request->query["term"] . '%'),
                'limit' => 10
            ]);
          
            $data = array();$data1 = array();
            foreach($terms as $term) {
                $row = $term->firstname;
                array_push($data, $row);
            }
            $this->autoRender = false;      
            // $this->layout = 'ajax';
            $this->set('terms', $terms);
            echo json_encode($data);
            exit;
            //return json_encode($data);
         }else {
            //echo json_encode('Nothings found');
         }
         
        $mutualfund = $this->Mutualfunds->newEntity();
        if ($this->request->is('post')) {
            $mutualfund = $this->Mutualfunds->patchEntity($mutualfund, $this->request->data);
          
            $mutualfund->postedby = $this->Auth->user('id');
            $mutualfund->posteduserbranchid = $this->Auth->user('branch_id');
           // $mutualfund->branch_id = $this->Auth->user('branch_id');
           
            if($mutualfund->subbroker_id != ''){
                $mutualfund->broker_id = $mutualfund->subbroker_id;
            }else{
                $mutualfund->broker_id = 1;
            }
            
           $custmoerId = $this->getCustomerId($mutualfund->panno);
		  // $custmoerId = $this->Mutualfunds->Customers->find()->contain(['field'=>'id','value'=>'id'])
           if($custmoerId != ''){
                $mutualfund->customer_id = $custmoerId;
            }
            
             if($mutualfund->typeofdeposit == 'STP'){
                $mutualfund->bank_id = NULL;
                $mutualfund->chequeno = '';  
                $mutualfund->noofunit = 0; $mutualfund->newproductcompanyid = 0;  $mutualfund->newmfid = 0;  
            }elseif($mutualfund->typeofdeposit == 'SIP - Renewal'){
               // $mutualfund->bank_id = NULL; $mutualfund->chequeno = '';  
                $mutualfund->noofunit = 0; $mutualfund->newproductcompanyid = 0;  $mutualfund->newmfid = 0;
                $mutualfund->stpdate = NULL; $mutualfund->stpamount = 0;  $mutualfund->newstpfund = 0; $mutualfund->newstpscheme = 0;
            }elseif($mutualfund->typeofdeposit == 'Switch'){
                $mutualfund->bank_id = NULL; $mutualfund->chequeno = '';  
                $mutualfund->tenure = 0; $mutualfund->planstartdate = NULL;  $mutualfund->maturitydate = NULL;
                $mutualfund->stpdate = NULL; $mutualfund->stpamount = 0;  $mutualfund->newstpfund = 0; $mutualfund->newstpscheme = 0;
            }elseif($mutualfund->typeofdeposit == 'SIP'){
                $mutualfund->newproductcompanyid = 0; $mutualfund->noofunit = '';  
                $mutualfund->newmfid = 0; $mutualfund->customerfoliono = ''; 
                $mutualfund->stpdate = NULL; $mutualfund->stpamount = 0;  $mutualfund->newstpfund = 0; $mutualfund->newstpscheme = 0;
            }elseif($mutualfund->typeofdeposit == 'Fresh'){
                $mutualfund->tenure = 0; $mutualfund->planstartdate = NULL;  $mutualfund->maturitydate = NULL;
                $mutualfund->newproductcompanyid = 0; $mutualfund->noofunit = '';  
                $mutualfund->newmfid = 0; $mutualfund->customerfoliono = ''; 
                $mutualfund->stpdate = NULL; $mutualfund->stpamount = 0;  $mutualfund->newstpfund = 0; $mutualfund->newstpscheme = 0;
            }elseif($mutualfund->typeofdeposit == 'Additional'){
                $mutualfund->tenure = 0; $mutualfund->planstartdate = NULL;  $mutualfund->maturitydate = NULL;
                $mutualfund->newproductcompanyid = 0; $mutualfund->noofunit = '';  
                $mutualfund->newmfid = 0; 
                $mutualfund->stpdate = NULL; $mutualfund->stpamount = 0;  $mutualfund->newstpfund = 0; $mutualfund->newstpscheme = 0;
            }
          
            if ($this->Mutualfunds->save($mutualfund)) {
                $this->Flash->success(__('The mutualfund has been saved.'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The mutualfund could not be saved. Please, try again.'));
            }
        }
        $users = $this->Mutualfunds->Customers->find('list', ['limit' => 200]);
        $subbrokers = $this->Mutualfunds->Brokers->find('list', [
            'keyField' => 'id',
            'valueField' => 'name'
        ])-> where(['role' => 'Subbroker']);
        $usercompanies = $this->Mutualfunds->Companies->find('list')-> where(['associatewith' => 'user'])->order(['company' => 'ASC']);
        $branches = $this->Mutualfunds->Branches->find('list', ['limit' => 200]);
        //$productcompanies = $this->Mutualfunds->Companies->find('list')-> where(['associatewith' => 'product'])->order(['company' => 'ASC']);
        $productcompanies = $this->Mutualfunds->Companies->find('list')-> where(['associatewith' => 'product'])->where(['productid LIKE' => '%1%'])->order(['company' => 'ASC']);
        $banks = $this->Mutualfunds->Banks->find('list', ['limit' => 200])->order(['banks' => 'ASC']);
        $bankbranches = $this->Mutualfunds->Bankbranches->find('list', ['limit' => 200])->order(['branchaddress' => 'ASC']);
        $accounttype = array(
            'For Residents' => 'For Residents',
            'Saving' => 'Saving',
            'Current' => 'Current',
            'For Non Residents' => 'For Non Residents',
            'NRO' => 'NRO',
            'NRE' => 'NRE',
            'FCNR' => 'FCNR'      
        );
        $typeofdeposit = array(
            'Additional' => 'Additional',
            'Fresh' => 'Fresh',
            'SIP' => 'SIP',            
            'Switch' => 'Switch',
            'SIP - Renewal' => 'SIP - Renewal',
            'STP' => 'STP'
        );
        $mffunds = $this->Mutualfunds->Mffunds->find('list')->order(['fundname' => 'ASC']);
        $eunis = $this->Mutualfunds->Eunis->find('list')->order(['eunisno' => 'ASC']);
       // $customerNames = $this->Mutualfunds->Customers->getCustomerNames($term);
        
        $this->set(compact('mutualfund','eunis','mffunds', 'subbrokers','accounttype','typeofdeposit','banks','bankbranches', 'users','productcompanies','usercompanies', 'branches'));
        $this->set('_serialize', ['mutualfund']);
    }

    /**
     * Edit method
     *
     * @param string|null $id Mutualfund id.
     * @return \Cake\Network\Response|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
   public function edit($id = null)
    {
        if ($this->request->is('ajax','get')) {         
            $terms = $this->Mutualfunds->Customers->find('all', [
                'conditions' => array('Customers.firstname LIKE ' => '%' . $this->request->query["term"] . '%'),
                'limit' => 10
            ]);
          
            $data = array();$data1 = array();
            foreach($terms as $term) {
                $row = $term->firstname;
                array_push($data, $row);
            }
            $this->autoRender = false;      
            // $this->layout = 'ajax';
            $this->set('terms', $terms);
            echo json_encode($data);
            exit;
            //return json_encode($data);
         }else {
            //echo json_encode('Nothings found');
         }
         
        $mutualfund = $this->Mutualfunds->get($id, [
            'contain' => []
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $mutualfund = $this->Mutualfunds->patchEntity($mutualfund, $this->request->data);
            $mutualfund->postedby = $this->Auth->user('id');
            $mutualfund->posteduserbranchid = $this->Auth->user('branch_id');
           // $mutualfund->branch_id = $this->Auth->user('branch_id');
            if($mutualfund->broker_id == ''){             
                $mutualfund->broker_id = 1;
            }
           $custmoerId = $this->getCustomerId($mutualfund->panno);
           if($custmoerId != ''){
                $mutualfund->customer_id = $custmoerId;
            }
            
            
            if($mutualfund->typeofdeposit == 'STP'){
                $mutualfund->bank_id = 0;
                $mutualfund->chequeno = '';  
                $mutualfund->noofunit = 0; $mutualfund->newproductcompanyid = 0;  $mutualfund->newmfid = 0;  
            }elseif($mutualfund->typeofdeposit == 'SIP - Renewal'){
              //  $mutualfund->bank_id = 0; $mutualfund->chequeno = '';  
                $mutualfund->noofunit = 0; $mutualfund->newproductcompanyid = 0;  $mutualfund->newmfid = 0;
                $mutualfund->stpdate = ''; $mutualfund->stpamount = 0;  $mutualfund->newstpfund = 0; $mutualfund->newstpscheme = 0;
            }elseif($mutualfund->typeofdeposit == 'Switch'){
                $mutualfund->bank_id = 0; $mutualfund->chequeno = '';  
                $mutualfund->tenure = 0; $mutualfund->planstartdate = '';  $mutualfund->maturitydate = '';
                $mutualfund->stpdate = ''; $mutualfund->stpamount = 0;  $mutualfund->newstpfund = 0; $mutualfund->newstpscheme = 0;
            }elseif($mutualfund->typeofdeposit == 'SIP'){
                $mutualfund->newproductcompanyid = 0; $mutualfund->noofunit = '';  
                $mutualfund->newmfid = 0; $mutualfund->customerfoliono = ''; 
                $mutualfund->stpdate = ''; $mutualfund->stpamount = 0;  $mutualfund->newstpfund = 0; $mutualfund->newstpscheme = 0;
            }elseif($mutualfund->typeofdeposit == 'Fresh'){
                $mutualfund->tenure = 0; $mutualfund->planstartdate = '';  $mutualfund->maturitydate = '';
                $mutualfund->newproductcompanyid = 0; $mutualfund->noofunit = '';  
                $mutualfund->newmfid = 0; $mutualfund->customerfoliono = ''; 
                $mutualfund->stpdate = ''; $mutualfund->stpamount = 0;  $mutualfund->newstpfund = 0; $mutualfund->newstpscheme = 0;
            }elseif($mutualfund->typeofdeposit == 'Additional'){
                $mutualfund->tenure = 0; $mutualfund->planstartdate = '';  $mutualfund->maturitydate = '';
                $mutualfund->newproductcompanyid = 0; $mutualfund->noofunit = '';  
                $mutualfund->newmfid = 0; 
                $mutualfund->stpdate = ''; $mutualfund->stpamount = 0;  $mutualfund->newstpfund = 0; $mutualfund->newstpscheme = 0;
            }
            if ($this->Mutualfunds->save($mutualfund)) {
                $this->Flash->success(__('The mutualfund has been saved.'));

                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The mutualfund could not be saved. Please, try again.'));
            }
        }
        $users = $this->Mutualfunds->Customers->find('list', ['limit' => 200]);
        $subbrokers = $this->Mutualfunds->Brokers->find('list', [
            'keyField' => 'id',
            'valueField' => 'name'
        ])-> where(['role' => 'Subbroker']);
    
       $usercompanies = $this->Mutualfunds->Companies->find('list')-> where(['associatewith' => 'user'])->order(['company' => 'ASC']);
        $branches = $this->Mutualfunds->Branches->find('list', ['limit' => 200]);
        //$productcompanies = $this->Mutualfunds->Companies->find('list')-> where(['associatewith' => 'product'])->order(['company' => 'ASC']);
        $productcompanies = $this->Mutualfunds->Companies->find('list')-> where(['associatewith' => 'product'])->where(['productid LIKE' => '%1%'])->order(['company' => 'ASC']);
        $banks = $this->Mutualfunds->Banks->find('list', ['limit' => 200])->order(['banks' => 'ASC']);
        $bankbranches = $this->Mutualfunds->Bankbranches->find('list', ['limit' => 200])->order(['branchaddress' => 'ASC']);
        $accounttype = array(
            'For Residents' => 'For Residents',
            'Saving' => 'Saving',
            'Current' => 'Current',
            'For Non Residents' => 'For Non Residents',
            'NRO' => 'NRO',
            'NRE' => 'NRE',
            'FCNR' => 'FCNR'      
        );
        $typeofdeposit = array(
            'Additional' => 'Additional',
            'Fresh' => 'Fresh',
            'SIP' => 'SIP',            
            'Switch' => 'Switch',
            'SIP - Renewal' => 'SIP - Renewal',
            'STP' => 'STP'      
        );
       $mffunds = $this->Mutualfunds->Mffunds->find('list')->order(['fundname' => 'ASC']);
        $eunis = $this->Mutualfunds->Eunis->find('list')->order(['eunisno' => 'ASC']);
        
        $this->set(compact('mutualfund','accounttype','eunis','subbrokers','typeofdeposit','mffunds','banks','bankbranches', 'users', 'productcompanies','usercompanies', 'branches'));
        $this->set('_serialize', ['mutualfund']);        
        
    }

    /**
     * Delete method
     *
     * @param string|null $id Mutualfund id.
     * @return \Cake\Network\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $mutualfund = $this->Mutualfunds->get($id);
        if ($this->Mutualfunds->delete($mutualfund)) {
            $this->Flash->success(__('The mutualfund has been deleted.'));
        } else {
            $this->Flash->error(__('The mutualfund could not be deleted. Please, try again.'));
        }

        return $this->redirect(['action' => 'index']);
    }
    public function mutualfundsupdate(){
	   $this->Search->addFilter('firstname', [
          'attributes'=>['placeholder'=>'Applicant Name','label'=>'Applicant Name :','class'=>'searchfrm','value' => isset($this->request->query['firstname'])?$this->request->query['firstname']:''], 'options' => $this->Mutualfunds->Customers->find('list',['keyField' => 'firstname','valueField' => 'firstname'])->order(['Customers.firstname'=>'ASC'])->group(['Customers.firstname'])->toArray(),
       ]);
		$this->Search->addFilter('datedform', [
         'attributes'=>['placeholder'=>'Start Date','label'=>'Start Date :','class'=>'searchfrm','value' => isset($this->request->query['datedform'])?$this->request->query['datedform']:''],
        ]);
        $this->Search->addFilter('datedto', [
           'attributes'=>['placeholder'=>'End Date','label'=>'End Date :','class'=>'searchfrm','value' => isset($this->request->query['datedto'])?$this->request->query['datedto']:''],
        ]);
        $conditions = '';  
        if($this->Auth->user('group_id')=='3'){        
            $branch_id = $this->Auth->user('branch_id');     
            $conditions['conditions']['and']['Mutualfunds.posteduserbranchid'] = "$branch_id";
        }elseif($this->Auth->user('group_id')=='4' || $this->Auth->user('group_id')=='5' || $this->Auth->user('group_id')=='6' || $this->Auth->user('group_id')=='7'){ 
            $branch_id = $this->Auth->user('branch_id');    
            $userid = $this->Auth->user('id'); 
            $conditions['conditions']['and']['Mutualfunds.posteduserbranchid'] = "$branch_id";
            $conditions['conditions']['and']['Mutualfunds.postedby'] = "$userid";
        }
	//	if (!empty($this->request->query)) 
	 if((!empty($this->request->query['firstname']))||(!empty($this->request->query['datedform'])) ||(!empty($this->request->query['datedto']))){ 
        
        $fapplicantname = $this->request->query['firstname'];    
        $dated2 =  (($this->request->query['datedform'] != '')? $this->request->query['datedform'] : '');
		$date_from = explode('/',$dated2);
        $datedform  = implode('-', array_reverse($date_from));
	    $dated1= (($this->request->query['datedto']!='')? $this->request->query['datedto']:'');
	    $date_to = explode('/',$dated1);
        $datedto  = implode('-', array_reverse($date_to));

		if ($datedform && $datedto){
			if($datedform == $datedto){
                $adt = new \DateTime($datedto);
                $adt->modify('+1 day');
                $datedto = $adt->format('Y-m-d');        
            }
                $conditions = array(
				'conditions' => array(
				'and' => array(
                        array('Mutualfunds.created >= ' => $datedform,
                            'Mutualfunds.created <= ' => $datedto
                ))));
            } 
            if ($fapplicantname){ $conditions['conditions']['or']['Mutualfunds.firstapplicantname'] = "$fapplicantname"; }
            if (( $fapplicantname != '')  || ($datedform && $datedto)){ 
			        $mutualfunds = $this->Mutualfunds->find('all', $conditions);
					$cnt = $mutualfunds->count();              
					if($mutualfunds){
						$total_amount = 0;                   
						 foreach ($mutualfunds as $md){ 
							$total_amount += $md->amount;
						 }
					} 
            }else{
				if($conditions !=''){
				$mutualfunds = $this->Mutualfunds->find('all', $conditions);
					
				$cnt = $mutualfunds->count();              
					if($mutualfunds){
						$total_amount = 0;                   
						 foreach ($mutualfunds as $md){ 
							$total_amount += $md->amount;
						 }
					} 
				}else{
				 $mutualfunds = $this->Mutualfunds; 
				 $mf1=$this->Mutualfunds->find('all',array('contain' => ['Companies', 'Branches', 'Mffunds','Brokers']));
				$cnt = $mf1->count();              
					if($mf1){
					   $total_amount = 0;                   
						 foreach ($mf1 as $md){ 
								$total_amount += $md->amount;
						 }
					} 
				}
            }    
            $this->paginate = [
               'contain' => ['Companies']
            ]; 
			$mutualfunds = $this->paginate($mutualfunds ,['order' => ['Mutualfunds.firstapplicantname' => 'ASC']]);
            $this->set(compact('mutualfunds','total_amount','cnt'));
            $this->set('_serialize', ['mutualfunds']);
		}
		else{
        $this->paginate = [
            'contain' => ['Companies']
        ];
        $conditions['conditions']['or']['DATE(Mutualfunds.created) > '] = date('Y-m-d');
        $mutualfunds = $this->Mutualfunds->find('all', $conditions);
		
		$cnt = $mutualfunds->count();              
		if($mutualfunds){
			$total_amount = 0;                   
			 foreach ($mutualfunds as $md){ 
				$total_amount += $md->amount;
			 }
		} 
        $mutualfunds = $this->paginate($mutualfunds,['order' => ['Mutualfunds.firstapplicantname' => 'DESC']]);
        $this->set(compact('mutualfunds','total_amount','cnt'));
        $this->set('_serialize', ['mutualfunds']);
		}
    }
    public function swichallrecords(){
		$this->loadModel('Mutualfunds');     
		$this->loadModel('Customers'); 
		$this->loadModel('Banks'); 
		//$this->loadModel('Plans'); 
		$this->loadModel('Products');
		$this->loadModel('Companies');
		
		$all = array('all'=>'All');
		//if($this->Auth->user('group_id')=='2'){ 
           $branch = $this->Mutualfunds->Branches->find('list')->toArray();   
           $this->Search->addFilter('branch', [
            'attributes'=>['placeholder'=>'Branch Name','label'=>'Branch Name :','class'=>'searchfrm','value' => isset($this->request->query['branch'])?$this->request->query['branch']:''],  
            'options' => $all+$this->Mutualfunds->Branches->find('list')->toArray(),
        ]);
        //} 
		
		$this->Search->addFilter('username', [
          'attributes'=>['placeholder'=>'User Name','label'=>'User Name :','class'=>'searchfrm','value' => isset($this->request->query['username'])?$this->request->query['username']:''], 'options' => $all+$this->Mutualfunds->Users->find('list',['keyField' => 'id','valueField' => 'username'])->order(['Users.username'=>'ASC'])->group(['Users.username'])->toArray(),
        ]);	
		$this->Search->addFilter('datedform', [
         'attributes'=>['placeholder'=>'Start Date','label'=>'Start Date :','class'=>'searchfrm','value' => isset($this->request->query['datedform'])?$this->request->query['datedform']:''],
        ]);
        $this->Search->addFilter('datedto', [
           'attributes'=>['placeholder'=>'End Date','label'=>'End Date :','class'=>'searchfrm','value' => isset($this->request->query['datedto'])?$this->request->query['datedto']:''],
        ]);
		
        $conditions = ''; 

		if((!empty($this->request->query['datedform'])) ||(!empty($this->request->query['datedto']))){ 
			$dated2 =  (($this->request->query['datedform'] != '')? $this->request->query['datedform'] : '');
			$date_from = explode('/',$dated2);
			$datedform  = implode('-', array_reverse($date_from));
			$dated1= (($this->request->query['datedto']!='')? $this->request->query['datedto']:'');
			$date_to = explode('/',$dated1);
			$datedto  = implode('-', array_reverse($date_to));	
			if ($datedform && $datedto){
				if($datedform == $datedto){
					$adt = new \DateTime($datedto);
					$adt->modify('+1 day');
					$datedto = $adt->format('Y-m-d');        
				}
			$conditions = array('conditions' => array('and' => array(array('Mutualfunds.created >= ' => $datedform,'Mutualfunds.created <= ' => $datedto))));
			} 
        }
		if((!empty($this->request->query['branch']))){ 
				$branch = (($this->request->query['branch'] != '')? $this->request->query['branch'] : ''); 
				if (($branch !='') && ($branch !='all')){ $conditions['conditions']['and']['Mutualfunds.branch_id'] = "$branch"; }
		}
		if((!empty($this->request->query['username']))){ 
				$username = (($this->request->query['username'] != '')? $this->request->query['username'] : ''); 
				if (($username !='') && ($username !='all')){ $conditions['conditions']['and']['Mutualfunds.postedby'] = "$username"; }
		}
		$conditions['conditions']['and']['Mutualfunds.swichall'] = 1;	
		$mutualfunds = $this->Mutualfunds->find('all', $conditions);
		//debug($conditions);
		$this->paginate = [
			'contain' => ['Companies', 'Branches','Brokers']
		]; 
		$mutualfunds = $this->paginate($mutualfunds ,['order' => ['Mutualfunds.created' => 'DESC']]);
		$this->set(compact('mutualfunds'));
		$this->set('_serialize', ['mutualfunds']);
	}
	
	 public function getbranchuserinfo(){
        $branch_id = $this->request->query('branch_id');
	   	$connection = ConnectionManager::get('default');
        if (empty($branch_id) || ($branch_id == 'all')){
           $data= $connection->execute('SELECT id,username FROM users')->fetchAll('assoc');    	
        }else{
		$data= $connection->execute('SELECT id,username FROM users WHERE branch_id = :branch',['branch'=>$branch_id])->fetchAll('assoc');    	
		}
        $this->set(compact('data'));          
    } 
    public function getuserinfo(){
       $id = $this->request->query('id');
        if (!$id) {
            throw new NotFoundException();
        }
        //$query = $this->Mutualfunds->Customers->find('all',['conditions' => ['id' => $id]]);  
        $query = $this->Mutualfunds->Customers->find('all',['conditions' => array('Customers.firstname LIKE ' => '%' . $id . '%')]);    
        $data = $query->toArray(); 
        $this->set(compact('data'));          
    } 
    
    public function getbankinfo(){
        $id = $this->request->query('id');
        if (!$id) {
            throw new NotFoundException();
        }   
        $data = $this->Mutualfunds->Bankbranches->find('all',['conditions' => ['id' => $id]]); 
        $this->set(compact('data')); 
    }
    public function getbankbranchinfo(){
        $id = $this->request->query('id');
        if (!$id) {
            throw new NotFoundException();
        }   
        $query = $this->Mutualfunds->Bankbranches->find('all',['conditions' => ['id' => $id]]); 
        $data = $query->toArray();       
        $this->set(compact('data')); 
    } 
    public function getschemeinfo(){
        $company_id = $this->request->query('company_id');
        if (!$company_id) {
            throw new NotFoundException();
        }   
        $query = $this->Mutualfunds->Mffunds->find('all',['conditions' => ['company_id' => $company_id]]); 
        $data = $query->toArray();       
        $this->set(compact('data')); 
    } 
    public function geteuniinfo(){
        $company_id = $this->request->query('company_id');
        if (!$company_id) {
            throw new NotFoundException();
        }   
        $query = $this->Mutualfunds->Eunis->find('all',['conditions' => ['company_id' => $company_id]]); 
        $data = $query->toArray();       
        $this->set(compact('data')); 
    } 
	public function getuserpaninfo(){
		$customer_id = $this->request->query('customer_id');
		//$customer_id = 1281;
		$this->loadModel('Customers'); 
		$query = $this->Customers->find('all',['conditions' => ['id' => $customer_id]]);
		$data = $query->toArray();
		//debug($data);
		$this->set(compact('data'));
	}
      
}
