<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Subbrokers Model
 *
 * @property \Cake\ORM\Association\HasMany $Fds
 * @property \Cake\ORM\Association\HasMany $Investments
 *
 * @method \App\Model\Entity\Subbroker get($primaryKey, $options = [])
 * @method \App\Model\Entity\Subbroker newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Subbroker[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Subbroker|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Subbroker patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Subbroker[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Subbroker findOrCreate($search, callable $callback = null)
 */
class SubbrokersTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('subbrokers');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->hasMany('Fds', [
            'foreignKey' => 'subbroker_id'
        ]);
        $this->hasMany('Investments', [
            'foreignKey' => 'subbroker_id'
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->requirePresence('subbroker', 'create')
            ->notEmpty('subbroker');

        return $validator;
    }
}
