<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Customers Model
 *
 * @property \Cake\ORM\Association\BelongsTo $Groups
 * @property \Cake\ORM\Association\BelongsTo $Companies
 * @property \Cake\ORM\Association\BelongsTo $Branches
 *
 * @method \App\Model\Entity\Customer get($primaryKey, $options = [])
 * @method \App\Model\Entity\Customer newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Customer[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Customer|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Customer patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Customer[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Customer findOrCreate($search, callable $callback = null)
 *
 * @mixin \Cake\ORM\Behavior\TimestampBehavior
 */
class CustomersTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('customers');
		
        $this->displayField('accountno');
        $this->primaryKey('id');

        $this->addBehavior('Timestamp');

      /*  $this->belongsTo('Groups', [
            'foreignKey' => 'group_id',
            'joinType' => 'INNER'
        ]); */
        $this->belongsTo('Companies', [
            'foreignKey' => 'company_id',
            'joinType' => 'INNER'
        ]);
        $this->belongsTo('Branches', [
            'foreignKey' => 'branch_id',
            'joinType' => 'INNER'
        ]);
        $this->hasMany('Fds', [
            'foreignKey' => 'customer_id'
        ]);
        $this->hasMany('Ncds', [
            'foreignKey' => 'customer_id'
        ]);
        $this->hasMany('Mutualfunds', [
            'foreignKey' => 'customer_id'
        ]);
        $this->hasMany('Ipos', [
            'foreignKey' => 'customer_id'
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->requirePresence('accountno', 'create')
            ->notEmpty('accountno');

        $validator
            ->requirePresence('firstname', 'create')
            ->notEmpty('firstname');
   /* chnages:
    * desabled all validator;
	*/
       

      /*  $validator
            ->requirePresence('panno', 'create')
            ->notEmpty('panno')
            ->add('panno',['maxLength' => array(
                'rule' => array('maxLength', 10),
                'message' => '10 digit no'
                ), 
                'minLength' => array(
                'rule' => array('minLength', 10),
                'message' => '10 digit Number'
            )]);
         $validator
            ->requirePresence('gender', 'create')
            ->notEmpty('gender');

         $validator
            ->integer('phoneno')
            ->requirePresence('phoneno', 'create')
            ->notEmpty('phoneno');   
      /*      
         $validator
            ->requirePresence('lastname', 'create')
            ->notEmpty('lastname');

        $validator
            ->requirePresence('dob', 'create')
            ->notEmpty('dob');    
        $validator
            ->email('email')
            ->requirePresence('email', 'create')
            ->notEmpty('email');

        

        $validator
            ->requirePresence('address', 'create')
            ->notEmpty('address');

        $validator
            ->requirePresence('City', 'create')
            ->notEmpty('City');

        $validator
            ->requirePresence('State', 'create')
            ->notEmpty('State');

        $validator
            ->requirePresence('Country', 'create')
            ->notEmpty('Country');

      $validator
            ->requirePresence('Zipcode', 'create')
            ->notEmpty('Zipcode');
  
        

        $validator
            ->allowEmpty('photo');*/

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        //$rules->add($rules->isUnique(['email']));
//$rules->add($rules->existsIn(['group_id'], 'Groups'));
        $rules->add($rules->existsIn(['company_id'], 'Companies'));
        $rules->add($rules->existsIn(['branch_id'], 'Branches'));

        return $rules;
    }
}
