<?php
/**
 * CakePHP(tm) : Rapid Development Framework (http://cakephp.org)
 * Copyright (c) Cake Software Foundation, Inc. (http://cakefoundation.org)
 *
 * Licensed under The MIT License
 * For full copyright and license information, please see the LICENSE.txt
 * Redistributions of files must retain the above copyright notice.
 *
 * @copyright     Copyright (c) Cake Software Foundation, Inc. (http://cakefoundation.org)
 * @link          http://cakephp.org CakePHP(tm) Project
 * @since         0.10.0
 * @license       http://www.opensource.org/licenses/mit-license.php MIT License
 */

$cakeDescription = 'ABN Financial Management';
?>
<!DOCTYPE>
<html>
<head>
    <?= $this->Html->charset() ?>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>
        <?= $cakeDescription ?>:
        <?= $this->fetch('title') ?>
    </title>
    <?= $this->Html->meta('icon') ?>

    <?= $this->Html->script('jquery.js'); ?>
    <?= $this->Html->css(
            'http://ajax.googleapis.com/ajax/libs/jqueryui/1.11.1/themes/smoothness/jquery-ui.css',
            array(
                'inline' => false
            )
        );?>
    <?= $this->Html->script(
                'https://ajax.googleapis.com/ajax/libs/jqueryui/1.11.1/jquery-ui.min.js',
            array(
                'inline' => false
            )
        );
    ?>
 <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/v/dt/dt-1.10.18/datatables.min.css"/>
<script type="text/javascript" src="https://cdn.datatables.net/v/dt/dt-1.10.18/datatables.min.js"></script>   
        <!-- Latest compiled and minified CSS -->
<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css" integrity="sha384-BVYiiSIFeK1dGmJRAkycuHAHRg32OmUcww7on3RYdg4Va+PmSTsz/K68vbdEjh4u" crossorigin="anonymous">

<!-- Optional theme -->
<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap-theme.min.css" integrity="sha384-rHyoN1iRsVXV4nD0JutlnGaslCJuC7uwjduW9SVrLvRYooPp2bWYgmgJQIXwl/Sp" crossorigin="anonymous">

<!-- Latest compiled and minified JavaScript -->
<script src="//oss.maxcdn.com/bootbox/4.2.0/bootbox.min.js"></script>
<script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/js/bootstrap.min.js" integrity="sha384-Tc5IQib027qvyjSMfHjOMaLkfuWVxZxUPnCJA7l2mCWNIpG9mGCD8wGNIcPD7Txa" crossorigin="anonymous"></script>

    
    <?= $this->Html->css('base.css') ?>
    <?= $this->Html->css('cake.css') ?>
    <?= $this->Html->css('custom.css') ?>
    <?= $this->Html->css('style.css') ?>
   
    <?= $this->Html->script('custom.js'); ?>
    
    <?= $this->fetch('meta') ?>
    <?= $this->fetch('css') ?>
    <?= $this->fetch('script') ?>
    
    
    
</head>
<body>
    <?php if (!is_null($this->request->session()->read('Auth.User.id'))) { ?>
    <nav class="top-bar expanded" data-topbar role="navigation">
       <ul class="title-area large-3 medium-4 columns top-cont content">
		<li class="header-title"><?php //echo $this->Html->image('logo.jpg', array('url'=>'/','class'=>'logo')); ?>ABN INVESTMENTS</li>
           <!--  <li class="name">
                <h1><a href=""><?= $this->fetch('title') ?></a></h1>
            </li> -->
        </ul>
        <div class="top-bar-section">
            <ul class="right">            
              <?php
                if (!is_null($this->request->session()->read('Auth.User.id'))) {
                   // user is logged in, show logout..user menu etc
                   echo "<li>".$this->Html->link('Logout', array('controller' => 'users', 'action' => 'logout'))."</li>"; 
                } else {
                   // echo "<li>".$this->Html->link('Register', array('controller' => 'users', 'action' => 'register'))."</li>";   
                   // the user is not logged in
                   echo "<li>".$this->Html->link('Login', array('controller' => 'users', 'action' => 'login'))."</li>"; 
                }
                ?>
            </ul>
        </div>
    </nav>
	<?php } ?>
	<div id="">
			<?php echo $this->element('menulist'); ?>
	</div>
	
    <?= $this->Flash->render() ?>
    <div class="container clearfix">
        <?= $this->fetch('content'); ?>
    </div>
	
   <div id="footer">
			<?php echo $this->element('footer'); ?>
		</div>
</body>
</html>
