<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Mutualfunds Model
 *
 * @property \Cake\ORM\Association\BelongsTo $Users
 * @property \Cake\ORM\Association\BelongsTo $Companies
 * @property \Cake\ORM\Association\BelongsTo $Branches
 * @property \Cake\ORM\Association\HasMany $Investments
 * @property \Cake\ORM\Association\BelongsTo $Banks
 * @property \Cake\ORM\Association\BelongsTo $Bankbranches
 * 
 * @method \App\Model\Entity\Mutualfund get($primaryKey, $options = [])
 * @method \App\Model\Entity\Mutualfund newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Mutualfund[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Mutualfund|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Mutualfund patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Mutualfund[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Mutualfund findOrCreate($search, callable $callback = null)
 */
class MutualfundsTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('mutualfunds');
        $this->displayField('applicationno');
        $this->primaryKey('id');

        $this->belongsTo('Brokers', [
            'foreignKey' => 'broker_id',
            'joinType' => 'INNER'
        ]);
        $this->belongsTo('Customers', [
            'foreignKey' => 'customer_id',
            'joinType' => 'INNER'
        ]);
        $this->belongsTo('Companies', [
            'foreignKey' => 'company_id',
            'joinType' => 'INNER'
        ]);
        $this->belongsTo('Branches', [
            'foreignKey' => 'branch_id',
            'joinType' => 'INNER'
        ]);
        $this->hasMany('Investments', [
            'foreignKey' => 'mutualfund_id'
        ]);
        $this->belongsTo('Banks', [
            'foreignKey' => 'bank_id',
            'joinType' => 'INNER'
        ]);
        $this->belongsTo('Bankbranches', [
            'foreignKey' => 'bankbranch_id',
            'joinType' => 'INNER'
        ]);
         $this->belongsTo('Mffunds', [
            'foreignKey' => 'mffund_id',
            'joinType' => 'INNER'
        ]);
        $this->belongsTo('Eunis', [
            'foreignKey' => 'euni_id',
            'joinType' => 'INNER'
        ]); 
        $this->belongsTo('Users',[
            'foreignKey' => 'postedby',
            'joinType' => 'INNER'
            ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');
 /*  $validator
            ->requirePresence('bank_id', 'create')
            ->notEmpty('bank_id');
        $validator
            ->requirePresence('customerFolioNo', 'create')
            ->notEmpty('customerFolioNo');
      */  
       
        
        $validator
            ->integer('productcompanyid')
            ->requirePresence('productcompanyid', 'create')
            ->notEmpty('productcompanyid');
        $validator
            ->requirePresence('mffund_id', 'create')
            ->notEmpty('mffund_id');
      /* $validator
            ->requirePresence('branch_id', 'create')
            ->notEmpty('branch_id'); */
        $validator
            ->requirePresence('company_id', 'create')
            ->notEmpty('company_id');
        $validator
            ->requirePresence('euni_id', 'create')
            ->notEmpty('euni_id');
        $validator
            ->requirePresence('despatchdate', 'create')
            ->notEmpty('despatchdate');
        $validator
            ->requirePresence('typeofdeposit', 'create')
            ->notEmpty('typeofdeposit'); 
            $validator
            ->requirePresence('panno', 'create')
            ->notEmpty('panno');
         $validator
            ->requirePresence('firstapplicantname', 'create')
            ->notEmpty('firstapplicantname');
    /*
        $validator
            ->requirePresence('advisorARNcode', 'create')
            ->notEmpty('advisorARNcode');

        $validator
            ->requirePresence('subbrokerbranchcode', 'create')
            ->notEmpty('subbrokerbranchcode');

        $validator
            ->requirePresence('subbrokerARN', 'create')
            ->notEmpty('subbrokerARN');

        $validator
            ->requirePresence('representativeEUIN', 'create')
            ->notEmpty('representativeEUIN');

       

        $validator
            ->requirePresence('customerFolioNo', 'create')
            ->notEmpty('customerFolioNo');
    */
        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['customer_id'], 'Customers'));
        $rules->add($rules->existsIn(['company_id'], 'Companies'));
        $rules->add($rules->existsIn(['branch_id'], 'Branches'));
       // $rules->add($rules->existsIn(['bank_id'], 'Banks'));
        $rules->add($rules->existsIn(['bankbranch_id'], 'Bankbranches'));
        $rules->add($rules->existsIn(['mffund_id'], 'Mffunds'));
        $rules->add($rules->existsIn(['broker_id'], 'Brokers'));
        $rules->add($rules->existsIn(['euni_id'], 'Eunis'));
        return $rules;
    }
    
    
}
